/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.attribute;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.attribute.IModifierOp;
import dev.toma.gunsrpg.api.common.attribute.IModifierOperator;
import dev.toma.gunsrpg.common.attribute.ModifierOperation;
import dev.toma.gunsrpg.common.attribute.OperationTarget;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public final class AttributeOps {
    private static final Map<ResourceLocation, IModifierOp> OPERATION_MAP = new HashMap<ResourceLocation, IModifierOp>();
    public static final IModifierOp SUM = AttributeOps.create("sum", OperationTarget.BEFORE_MULTIPLY, Double::sum);
    public static final IModifierOp SUB = AttributeOps.create("sub", OperationTarget.BEFORE_MULTIPLY, (v1, v2) -> v1 - v2);
    public static final IModifierOp MUL = AttributeOps.create("mul", OperationTarget.MULTIPLIER, (v1, v2) -> v1 * v2);
    public static final IModifierOp MULB = AttributeOps.create("mulb", OperationTarget.MULTIPLIER, (v1, v2) -> v1 * (1.0 + v2));
    public static final IModifierOp SET = AttributeOps.create("set", OperationTarget.BEFORE_MULTIPLY, (v1, v2) -> v2);

    public static IModifierOp register(IModifierOp op) {
        OPERATION_MAP.put(op.getId(), op);
        return op;
    }

    public static IModifierOp find(ResourceLocation id) {
        return OPERATION_MAP.get(id);
    }

    private static IModifierOp create(String id, OperationTarget target, IModifierOperator operator) {
        return AttributeOps.create(id, target, operator, 0);
    }

    private static IModifierOp create(String id, OperationTarget target, IModifierOperator operator, int executionOrder) {
        ModifierOperation op = new ModifierOperation(GunsRPG.makeResource(id), target, operator, executionOrder);
        AttributeOps.register(op);
        return op;
    }

    private AttributeOps() {
    }
}

